/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org2.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org2.eclipse.php.internal.debug.core.zend.communication.CommunicationUtilities;
import org2.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageRequestImpl;

public class AssignValueRequest
extends DebugMessageRequestImpl
implements IDebugRequestMessage {
    private String var;
    private String value;
    private int depth;
    private String[] path;

    public void setVar(String var) {
        this.var = var;
    }

    public String getVar() {
        return this.var;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setPath(String[] path) {
        if (path == null) {
            this.path = new String[0];
            return;
        }
        this.path = new String[path.length];
        System.arraycopy(path, 0, this.path, 0, path.length);
    }

    public String[] getPath() {
        return this.path;
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        this.setID(in.readInt());
        this.setVar(CommunicationUtilities.readEncodedString(in, this.getTransferEncoding()));
        this.setValue(CommunicationUtilities.readEncodedString(in, this.getTransferEncoding()));
        this.setDepth(in.readInt());
        int pathSize = in.readInt();
        if (pathSize > 0) {
            String[] path = new String[pathSize];
            int i = 0;
            while (i < pathSize) {
                path[i] = CommunicationUtilities.readString(in);
                ++i;
            }
            this.setPath(path);
        }
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        out.writeShort(this.getType());
        out.writeInt(this.getID());
        CommunicationUtilities.writeEncodedString(out, this.getVar(), this.getTransferEncoding());
        CommunicationUtilities.writeEncodedString(out, this.getValue(), this.getTransferEncoding());
        out.writeInt(this.getDepth());
        String[] path = this.getPath();
        out.writeInt(path.length);
        int i = 0;
        while (i < path.length) {
            CommunicationUtilities.writeString(out, path[i]);
            ++i;
        }
    }
}

